/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.constants.EnumParts;

public class ModData {
    private static NBTTagCompound exampleBlocks;
    private static NBTTagCompound exampleItems;
    private static NBTTagCompound exampleParticles;

    public static NBTTagCompound getExampleBlocks() {
        if (exampleBlocks == null) {
            exampleBlocks = new NBTTagCompound();
            NBTTagList listBlocks = new NBTTagList();
            listBlocks.func_74742_a((NBTBase)ModData.getExampleBlock());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleFacingBlock());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleLiquid());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleChest());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleContainer());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleStairs());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleSlab());
            listBlocks.func_74742_a((NBTBase)ModData.getExamplePortal());
            listBlocks.func_74742_a((NBTBase)ModData.getExampleDoor());
            exampleBlocks.func_74782_a("Blocks", (NBTBase)listBlocks);
        }
        return exampleBlocks;
    }

    private static NBTTagCompound getExampleBlock() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "blockexample");
        compound.func_74774_a("BlockType", (byte)0);
        compound.func_74776_a("Hardness", 5.0f);
        compound.func_74776_a("Resistance", 10.0f);
        compound.func_74776_a("LightLevel", 0.0f);
        compound.func_74778_a("SoundType", "GROUND");
        compound.func_74778_a("Material", "STONE");
        NBTTagList aabb = new NBTTagList();
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0625));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0625));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0625));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.9375));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.9375));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.9375));
        compound.func_74782_a("AABB", (NBTBase)aabb);
        compound.func_74778_a("BlockRenderType", "MODEL");
        compound.func_74757_a("IsLadder", false);
        compound.func_74757_a("IsPassable", false);
        compound.func_74757_a("IsOpaqueCube", false);
        compound.func_74757_a("IsFullCube", false);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleFacingBlock() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "facingblockexample");
        compound.func_74774_a("BlockType", (byte)0);
        compound.func_74778_a("BlockRenderType", "MODEL");
        NBTTagCompound nbtProperty = new NBTTagCompound();
        nbtProperty.func_74774_a("Type", (byte)4);
        nbtProperty.func_74778_a("Name", "facing");
        compound.func_74782_a("Property", (NBTBase)nbtProperty);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleLiquid() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "liquidexample");
        compound.func_74774_a("BlockType", (byte)1);
        compound.func_74776_a("Resistance", 2.0f);
        compound.func_74768_a("Density", 1100);
        compound.func_74757_a("IsGaseous", false);
        compound.func_74768_a("Luminosity", 5);
        compound.func_74768_a("Viscosity", 900);
        compound.func_74768_a("Temperature", 300);
        compound.func_74768_a("Color", -1);
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74778_a("Material", "WATER");
        return compound;
    }

    private static NBTTagCompound getExampleChest() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "chestexample");
        compound.func_74774_a("BlockType", (byte)2);
        compound.func_74778_a("Material", "WOOD");
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74757_a("IsChest", true);
        compound.func_74768_a("Size", 14);
        compound.func_74768_a("GUIColor", 4631430);
        compound.func_74778_a("Name", "Custom Chest");
        return compound;
    }

    private static NBTTagCompound getExampleContainer() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "containerexample");
        compound.func_74774_a("BlockType", (byte)2);
        compound.func_74778_a("Material", "STONE");
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74768_a("Size", 96);
        compound.func_74783_a("GUIColor", new int[]{56460, 14450688});
        compound.func_74778_a("Name", "Custom Container");
        NBTTagList aabb = new NBTTagList();
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0625));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.0625));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.9375));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(1.0));
        aabb.func_74742_a((NBTBase)new NBTTagDouble(0.9375));
        compound.func_74782_a("AABB", (NBTBase)aabb);
        return compound;
    }

    private static NBTTagCompound getExampleStairs() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "stairsexample");
        compound.func_74774_a("BlockType", (byte)3);
        compound.func_74778_a("Material", "STONE");
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74757_a("IsFullCube", false);
        compound.func_74757_a("IsOpaqueCube", false);
        return compound;
    }

    private static NBTTagCompound getExampleSlab() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "slabexample");
        compound.func_74774_a("BlockType", (byte)4);
        compound.func_74778_a("Material", "STONE");
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74757_a("IsFullCube", false);
        compound.func_74757_a("IsOpaqueCube", false);
        return compound;
    }

    private static NBTTagCompound getExamplePortal() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "portalexample");
        compound.func_74774_a("BlockType", (byte)5);
        compound.func_74778_a("Material", "PORTAL");
        NBTTagCompound nbtRender = new NBTTagCompound();
        nbtRender.func_74776_a("SecondSpeed", 800.0f);
        nbtRender.func_74778_a("SpawnParticle", "CRIT");
        nbtRender.func_74776_a("Transparency", 0.5f);
        compound.func_74782_a("RenderData", (NBTBase)nbtRender);
        compound.func_74768_a("DimensionID", 100);
        compound.func_74768_a("HomeDimensionID", 0);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleDoor() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "doorexample");
        compound.func_74774_a("BlockType", (byte)6);
        compound.func_74778_a("Material", "IRON");
        compound.func_74776_a("Hardness", 1.0f);
        compound.func_74776_a("Resistance", 25.0f);
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74757_a("InteractOpen", true);
        compound.func_74776_a("LightLevel", 2.0f);
        return compound;
    }

    public static NBTTagCompound getExampleItems() {
        if (exampleItems == null) {
            exampleItems = new NBTTagCompound();
            NBTTagList listItems = new NBTTagList();
            listItems.func_74742_a((NBTBase)ModData.getExampleItem());
            listItems.func_74742_a((NBTBase)ModData.getExampleWeapon());
            listItems.func_74742_a((NBTBase)ModData.getExampleTool());
            listItems.func_74742_a((NBTBase)ModData.getExampleAxe());
            listItems.func_74742_a((NBTBase)ModData.getExampleArmor());
            listItems.func_74742_a((NBTBase)ModData.getExampleOBJArmor());
            listItems.func_74742_a((NBTBase)ModData.getExampleShield());
            listItems.func_74742_a((NBTBase)ModData.getExampleBow());
            listItems.func_74742_a((NBTBase)ModData.getExampleFood());
            listItems.func_74742_a((NBTBase)ModData.getExampleFishingRod());
            exampleItems.func_74782_a("Items", (NBTBase)listItems);
            NBTTagList listPotion = new NBTTagList();
            listPotion.func_74742_a((NBTBase)ModData.getExamplePotion());
            exampleItems.func_74782_a("Potions", (NBTBase)listPotion);
        }
        return exampleItems;
    }

    private static NBTTagCompound getExampleItem() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "itemexample");
        compound.func_74774_a("ItemType", (byte)0);
        compound.func_74768_a("MaxStackSize", 64);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleWeapon() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "weaponexample");
        compound.func_74774_a("ItemType", (byte)1);
        compound.func_74768_a("MaxStackDamage", 2500);
        compound.func_74780_a("EntityDamage", 2.5);
        compound.func_74780_a("SpeedAttack", -2.4);
        compound.func_74757_a("IsFull3D", true);
        compound.func_74778_a("Material", "GOLD");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151074_bl).func_77955_b(new NBTTagCompound()));
        NBTTagCompound collectionMaterial = new NBTTagCompound();
        collectionMaterial.func_74778_a("Material", "WEB");
        collectionMaterial.func_74776_a("Speed", 15.0f);
        compound.func_74782_a("CollectionMaterial", (NBTBase)collectionMaterial);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleTool() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "toolexample");
        compound.func_74774_a("ItemType", (byte)2);
        compound.func_74768_a("MaxStackDamage", 2000);
        compound.func_74757_a("IsFull3D", true);
        compound.func_74776_a("Efficiency", 4.0f);
        compound.func_74780_a("EntityDamage", 0.0);
        compound.func_74778_a("ToolClass", "pickaxe");
        compound.func_74778_a("Material", "GOLD");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151074_bl).func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("HarvestLevel", 2);
        compound.func_74768_a("Enchantability", 25);
        NBTTagList collectionBlocks = new NBTTagList();
        collectionBlocks.func_74742_a((NBTBase)new NBTTagString(Objects.requireNonNull(Blocks.field_150348_b.getRegistryName()).toString()));
        collectionBlocks.func_74742_a((NBTBase)new NBTTagString(Objects.requireNonNull(Blocks.field_150343_Z.getRegistryName()).toString()));
        compound.func_74782_a("CollectionBlocks", (NBTBase)collectionBlocks);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleAxe() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "axeexample");
        compound.func_74774_a("ItemType", (byte)2);
        compound.func_74768_a("MaxStackDamage", 2200);
        compound.func_74757_a("IsFull3D", true);
        compound.func_74776_a("Efficiency", 4.25f);
        compound.func_74780_a("EntityDamage", 5.0);
        compound.func_74778_a("ToolClass", "axe");
        compound.func_74778_a("Material", "GOLD");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151043_k).func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("HarvestLevel", 2);
        compound.func_74768_a("Enchantability", 28);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleArmor() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "armorexample");
        compound.func_74774_a("ItemType", (byte)3);
        compound.func_74780_a("EntityDamage", 0.0);
        compound.func_74768_a("RenderIndex", 4);
        compound.func_74778_a("Material", "GOLD");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151074_bl).func_77955_b(new NBTTagCompound()));
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74783_a("MaxStackDamage", new int[]{2250, 3100, 1800});
        NBTTagList slots = new NBTTagList();
        slots.func_74742_a((NBTBase)new NBTTagString("HEAD"));
        slots.func_74742_a((NBTBase)new NBTTagString("Chest"));
        slots.func_74742_a((NBTBase)new NBTTagString("feet"));
        compound.func_74782_a("EquipmentSlots", (NBTBase)slots);
        compound.func_74783_a("DamageReduceAmount", new int[]{5, 7, 4});
        NBTTagList toughness = new NBTTagList();
        toughness.func_74742_a((NBTBase)new NBTTagFloat(2.2f));
        toughness.func_74742_a((NBTBase)new NBTTagFloat(3.5f));
        toughness.func_74742_a((NBTBase)new NBTTagFloat(1.8f));
        compound.func_74782_a("Toughness", (NBTBase)toughness);
        return compound;
    }

    private static NBTTagCompound getExampleOBJArmor() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "armorobjexample");
        compound.func_74774_a("ItemType", (byte)3);
        NBTTagList toughness = new NBTTagList();
        toughness.func_74742_a((NBTBase)new NBTTagFloat(2.2f));
        toughness.func_74742_a((NBTBase)new NBTTagFloat(3.5f));
        toughness.func_74742_a((NBTBase)new NBTTagFloat(2.6f));
        toughness.func_74742_a((NBTBase)new NBTTagFloat(1.8f));
        compound.func_74782_a("Toughness", (NBTBase)toughness);
        compound.func_74783_a("DamageReduceAmount", new int[]{5, 7, 6, 4});
        compound.func_74778_a("Material", "IRON");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151042_j).func_77955_b(new NBTTagCompound()));
        compound.func_74783_a("MaxStackDamage", new int[]{2250, 3100, 2700, 1800});
        NBTTagList slots = new NBTTagList();
        slots.func_74742_a((NBTBase)new NBTTagString("HEAD"));
        slots.func_74742_a((NBTBase)new NBTTagString("Chest"));
        slots.func_74742_a((NBTBase)new NBTTagString("LeGs"));
        slots.func_74742_a((NBTBase)new NBTTagString("feet"));
        compound.func_74782_a("EquipmentSlots", (NBTBase)slots);
        compound.func_74780_a("EntityDamage", 0.0);
        NBTTagCompound objData = new NBTTagCompound();
        NBTTagList meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.HEAD.name));
        objData.func_74782_a("Head Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.BODY.name));
        objData.func_74782_a("Body Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.ARM_RIGHT.name));
        objData.func_74782_a("Arm Right Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.WRIST_RIGHT.name));
        objData.func_74782_a("Wrist Right Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.ARM_LEFT.name));
        objData.func_74782_a("Arm Left Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.WRIST_LEFT.name));
        objData.func_74782_a("Wrist Left Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.BELT.name));
        objData.func_74782_a("Belt Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.LEG_RIGHT.name));
        objData.func_74782_a("Leg Right Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.FOOT_RIGHT.name));
        objData.func_74782_a("Foot Right Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.LEG_LEFT.name));
        objData.func_74782_a("Leg Left Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.FOOT_LEFT.name));
        objData.func_74782_a("Foot Left Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.FEET_LEFT.name));
        objData.func_74782_a("Boot Left Mesh Names", (NBTBase)meshes);
        meshes = new NBTTagList();
        meshes.func_74742_a((NBTBase)new NBTTagString(EnumParts.FEET_RIGHT.name));
        objData.func_74782_a("Boot Right Mesh Names", (NBTBase)meshes);
        compound.func_74782_a("OBJData", (NBTBase)objData);
        NBTTagCompound display = new NBTTagCompound();
        for (int s = 0; s < 4; ++s) {
            String slot = s == 0 ? "CHEST" : (s == 1 ? "LEGS" : (s == 2 ? "FEET" : "HEAD"));
            NBTTagCompound cameraData = new NBTTagCompound();
            for (int i = 0; i < 8; ++i) {
                String part;
                NBTTagList rotation = new NBTTagList();
                NBTTagList translation = new NBTTagList();
                NBTTagList scale = new NBTTagList();
                block0 : switch (i) {
                    case 0: {
                        int l;
                        part = "thirdperson_lefthand";
                        switch (slot) {
                            case "CHEST": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.15f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.35f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                }
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(90.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.15f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                }
                                break block0;
                            }
                            default: {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.375f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                        }
                    }
                    case 1: {
                        int l;
                        part = "thirdperson_righthand";
                        switch (slot) {
                            case "CHEST": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.35f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                }
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(90.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                }
                                break block0;
                            }
                            default: {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.375f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                        }
                    }
                    case 2: {
                        int l;
                        part = "firstperson_lefthand";
                        switch (slot) {
                            case "CHEST": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.57f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.1f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.085f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.4f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.085f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.72f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.435f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.585f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.85f));
                                }
                                break block0;
                            }
                            default: {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.57f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.225f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.085f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                        }
                    }
                    case 3: {
                        int l;
                        part = "firstperson_righthand";
                        switch (slot) {
                            case "CHEST": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.85f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.1f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.2f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.6f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.95f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.25f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.2f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.6f));
                                }
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.95f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.4f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.2f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.85f));
                                }
                                break block0;
                            }
                            default: {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(280.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.85f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.2f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.6f));
                                }
                                break block0;
                            }
                        }
                    }
                    case 4: {
                        part = "head";
                        switch (slot) {
                            case "CHEST": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(270.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.65f));
                                break block0;
                            }
                            case "LEGS": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(270.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(1.0f));
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.925f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.4f));
                                break block0;
                            }
                        }
                        break;
                    }
                    case 5: {
                        int l;
                        part = "gui";
                        switch (slot) {
                            case "CHEST": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(30.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(45.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.49f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.41f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.9f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(30.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(45.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.05f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                break;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(30.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(45.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.3f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                break;
                            }
                            default: {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(30.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(45.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-1.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                break;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int l;
                        part = "ground";
                        switch (slot) {
                            case "CHEST": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                            case "LEGS": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.25f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.6f));
                                }
                                break block0;
                            }
                            case "FEET": {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.35f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.65f));
                                }
                                break block0;
                            }
                            default: {
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.375f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                for (l = 0; l < 3; ++l) {
                                    scale.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                }
                                break block0;
                            }
                        }
                    }
                    default: {
                        int l;
                        part = "fixed";
                        switch (slot) {
                            case "CHEST": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(-0.65f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.45f));
                                break block0;
                            }
                            case "LEGS": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.05f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.475f));
                                break block0;
                            }
                            case "FEET": {
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                                rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.2f));
                                translation.func_74742_a((NBTBase)new NBTTagFloat(0.475f));
                                break block0;
                            }
                        }
                        rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                        rotation.func_74742_a((NBTBase)new NBTTagFloat(180.0f));
                        rotation.func_74742_a((NBTBase)new NBTTagFloat(0.0f));
                        translation.func_74742_a((NBTBase)new NBTTagFloat(0.5f));
                        translation.func_74742_a((NBTBase)new NBTTagFloat(-0.85f));
                        translation.func_74742_a((NBTBase)new NBTTagFloat(0.4f));
                        for (l = 0; l < 3; ++l) {
                            scale.func_74742_a((NBTBase)new NBTTagFloat(0.75f));
                        }
                    }
                }
                NBTTagCompound transform = new NBTTagCompound();
                if (rotation.func_74745_c() > 0) {
                    transform.func_74782_a("rotation", (NBTBase)rotation);
                }
                if (translation.func_74745_c() > 0) {
                    transform.func_74782_a("translation", (NBTBase)translation);
                }
                if (scale.func_74745_c() > 0) {
                    transform.func_74782_a("scale", (NBTBase)scale);
                }
                cameraData.func_74782_a(part, (NBTBase)transform);
            }
            display.func_74782_a(slot, (NBTBase)cameraData);
        }
        compound.func_74782_a("Display", (NBTBase)display);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleShield() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "shieldexample");
        compound.func_74774_a("ItemType", (byte)4);
        compound.func_74768_a("MaxStackDamage", 6500);
        compound.func_74780_a("EntityDamage", 0.0);
        compound.func_74778_a("Material", "IRON");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_191525_da).func_77955_b(new NBTTagCompound()));
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleBow() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "bowexample");
        compound.func_74774_a("ItemType", (byte)5);
        compound.func_74768_a("MaxStackDamage", 1250);
        compound.func_74780_a("EntityDamage", 2.0);
        compound.func_74778_a("Material", "WOOD");
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Blocks.field_150344_f).func_77955_b(new NBTTagCompound()));
        compound.func_74757_a("SetFlame", false);
        compound.func_74776_a("CritChance", 0.25f);
        compound.func_74776_a("DrawstringSpeed", 20.0f);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleFood() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "foodexample");
        compound.func_74774_a("ItemType", (byte)6);
        compound.func_74768_a("MaxStackSize", 32);
        compound.func_74768_a("UseDuration", 32);
        compound.func_74768_a("HealAmount", 1);
        compound.func_74776_a("SaturationModifier", 0.1f);
        compound.func_74757_a("IsWolfFood", false);
        compound.func_74757_a("AlwaysEdible", true);
        NBTTagCompound potionEffect = new NBTTagCompound();
        potionEffect.func_74778_a("Potion", "minecraft:fire_resistance");
        potionEffect.func_74768_a("DurationTicks", 45);
        potionEffect.func_74768_a("Amplifier", 0);
        potionEffect.func_74757_a("Ambient", true);
        potionEffect.func_74757_a("ShowParticles", false);
        potionEffect.func_74776_a("Probability", 0.95f);
        compound.func_74782_a("PotionEffect", (NBTBase)potionEffect);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExampleFishingRod() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "fishingrodexample");
        compound.func_74774_a("ItemType", (byte)8);
        compound.func_74768_a("MaxStackSize", 1);
        compound.func_74782_a("RepairItem", (NBTBase)new ItemStack(Items.field_151055_y).func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("MaxStackDamage", 150);
        compound.func_74768_a("Enchantability", 5);
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }

    private static NBTTagCompound getExamplePotion() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "potionexample");
        compound.func_74774_a("ItemType", (byte)7);
        compound.func_74757_a("CreateAllFiles", true);
        compound.func_74757_a("IsBadEffect", false);
        compound.func_74757_a("IsInstant", false);
        compound.func_74757_a("IsBeneficial", true);
        compound.func_74768_a("LiquidColor", 0xFFFFFF);
        compound.func_74768_a("MaxStackSize", 16);
        compound.func_74768_a("BaseDelay", 200);
        compound.func_74768_a("Duration", 20);
        compound.func_74782_a("CureItem", (NBTBase)new ItemStack(Items.field_151172_bF).func_77955_b(new NBTTagCompound()));
        NBTTagList potionModifiers = new NBTTagList();
        potionModifiers.func_74742_a((NBTBase)ModData.getExamplePotionModifier());
        compound.func_74782_a("Modifiers", (NBTBase)potionModifiers);
        return compound;
    }

    private static NBTTagCompound getExamplePotionModifier() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("AttributeName", "generic.maxHealth");
        compound.func_74778_a("UUID", UUID.randomUUID().toString());
        compound.func_74780_a("AttributeDefValue", 5.0);
        compound.func_74780_a("AttributeMinValue", -50.0);
        compound.func_74780_a("AttributeMaxValue", 50.0);
        compound.func_74780_a("Amount", 2.0);
        compound.func_74768_a("Operation", 2);
        return compound;
    }

    public static NBTTagCompound getExampleParticles() {
        if (exampleParticles == null) {
            exampleParticles = new NBTTagCompound();
            NBTTagList listItems = new NBTTagList();
            listItems.func_74742_a((NBTBase)ModData.getExampleParticle());
            listItems.func_74742_a((NBTBase)ModData.getExampleOBJParticle());
            exampleParticles.func_74782_a("Particles", (NBTBase)listItems);
        }
        return exampleParticles;
    }

    private static NBTTagCompound getExampleParticle() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "PARTICLE_EXAMPLE");
        compound.func_74757_a("ShouldIgnoreRange", false);
        compound.func_74768_a("ArgumentCount", 0);
        compound.func_74768_a("MaxAge", 60);
        compound.func_74783_a("UVpos", new int[]{1, 5});
        compound.func_74776_a("Gravity", 0.25f);
        compound.func_74776_a("Scale", 1.5f);
        compound.func_74778_a("Texture", "particles");
        compound.func_74757_a("IsFullTexture", false);
        compound.func_74757_a("CreateAllFiles", true);
        NBTTagList motion = new NBTTagList();
        motion.func_74742_a((NBTBase)new NBTTagDouble(0.2));
        motion.func_74742_a((NBTBase)new NBTTagDouble(0.1));
        motion.func_74742_a((NBTBase)new NBTTagDouble(0.2));
        compound.func_74782_a("StartMotion", (NBTBase)motion);
        compound.func_74757_a("IsRandomMotion", true);
        compound.func_74757_a("NotMotionY", true);
        return compound;
    }

    private static NBTTagCompound getExampleOBJParticle() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("RegistryName", "PARTICLE_OBJ_EXAMPLE");
        compound.func_74757_a("ShouldIgnoreRange", false);
        compound.func_74768_a("MaxAge", 60);
        compound.func_74776_a("Gravity", 0.33333334f);
        compound.func_74776_a("Scale", 1.0f);
        compound.func_74778_a("OBJModel", "ring");
        compound.func_74757_a("CreateAllFiles", true);
        return compound;
    }
}

